/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.softswitch.IntC8SoftSwitch;
import jace.apple2e.softswitch.KeyboardSoftSwitch;
import jace.apple2e.softswitch.Memory2SoftSwitch;
import jace.apple2e.softswitch.MemorySoftSwitch;
import jace.apple2e.softswitch.VideoSoftSwitch;
import jace.core.Computer;
import jace.core.RAMEvent;
import jace.core.SoftSwitch;

public enum SoftSwitches {
    _80STORE(new MemorySoftSwitch("80Store", 49152, 49153, 49176, RAMEvent.TYPE.WRITE, (Boolean)false)),
    AUXRD(new MemorySoftSwitch("AuxRead", 49154, 49155, 49171, RAMEvent.TYPE.WRITE, (Boolean)false)),
    AUXWR(new MemorySoftSwitch("AuxWrite", 49156, 49157, 49172, RAMEvent.TYPE.WRITE, (Boolean)false)),
    CXROM(new MemorySoftSwitch("IntCXROM", 49158, 49159, 49173, RAMEvent.TYPE.WRITE, (Boolean)false)),
    AUXZP(new MemorySoftSwitch("AuxZeroPage", 49160, 49161, 49174, RAMEvent.TYPE.WRITE, (Boolean)false)),
    SLOTC3ROM(new MemorySoftSwitch("C3ROM", 49162, 49163, 49175, RAMEvent.TYPE.WRITE, (Boolean)false)),
    INTC8ROM(new IntC8SoftSwitch()),
    LCBANK1(new MemorySoftSwitch("LangCardBank1", new int[]{49288, 49289, 49290, 49291, 49292, 49293, 49294, 49295}, new int[]{49280, 49281, 49282, 49283, 49284, 49285, 49286, 49287}, new int[]{49169}, RAMEvent.TYPE.READ, (Boolean)false)),
    LCRAM(new MemorySoftSwitch("LangCardRam/HRAMRD'", new int[]{49281, 49282, 49285, 49286, 49289, 49290, 49293, 49294}, new int[]{49280, 49283, 49284, 49287, 49288, 49291, 49292, 49295}, new int[]{49177}, RAMEvent.TYPE.READ, (Boolean)false)),
    LCWRITE(new Memory2SoftSwitch("LangCardWrite", new int[]{49280, 49282, 49284, 49286, 49288, 49290, 49292, 49294}, new int[]{49281, 49283, 49285, 49287, 49289, 49293, 49291, 49295}, new int[]{49170}, RAMEvent.TYPE.READ, (Boolean)false)),
    _80COL(new VideoSoftSwitch("80ColumnVideo (80COL/80VID)", 49164, 49165, 49183, RAMEvent.TYPE.WRITE, (Boolean)false)),
    ALTCH(new VideoSoftSwitch("Mousetext", 49166, 49167, 49182, RAMEvent.TYPE.WRITE, (Boolean)false)),
    TEXT(new VideoSoftSwitch("Text", 49232, 49233, 49178, RAMEvent.TYPE.ANY, (Boolean)false)),
    MIXED(new VideoSoftSwitch("Mixed", 49234, 49235, 49179, RAMEvent.TYPE.ANY, (Boolean)false)),
    PAGE2(new VideoSoftSwitch("Page2", 49236, 49237, 49180, RAMEvent.TYPE.ANY, (Boolean)false){

        @Override
        public void stateChanged() {
            if (_80STORE.isOn()) {
                Computer.getComputer().getMemory().configureActiveMemory();
            } else {
                Computer.getComputer().getVideo().configureVideoMode();
            }
        }
    }),
    HIRES(new VideoSoftSwitch("Hires", 49238, 49239, 49181, RAMEvent.TYPE.ANY, (Boolean)false)),
    IOUDIS(new VideoSoftSwitch("IOUDisable", 49278, 49279, 49278, RAMEvent.TYPE.ANY, (Boolean)false)),
    DHIRES(new VideoSoftSwitch("Double-hires", 49247, 49246, -1, RAMEvent.TYPE.ANY, (Boolean)false)),
    PB0(new MemorySoftSwitch("Pushbutton0", -1, -1, 49249, RAMEvent.TYPE.ANY, null)),
    PB1(new MemorySoftSwitch("Pushbutton1", -1, -1, 49250, RAMEvent.TYPE.ANY, null)),
    PB2(new MemorySoftSwitch("Pushbutton2", -1, -1, 49251, RAMEvent.TYPE.ANY, null)),
    PDLTRIG(new MemorySoftSwitch("PaddleTrigger", null, new int[]{49264, 49265, 49266, 49267, 49268, 49269, 49270, 49271, 49272, 49273, 49274, 49275, 49276, 49277, 49278, 49279}, null, RAMEvent.TYPE.ANY, (Boolean)false)),
    PDL0(new MemorySoftSwitch("Paddle0", -1, -1, 49252, RAMEvent.TYPE.ANY, (Boolean)false)),
    PDL1(new MemorySoftSwitch("Paddle1", -1, -1, 49253, RAMEvent.TYPE.ANY, (Boolean)false)),
    PDL2(new MemorySoftSwitch("Paddle2", -1, -1, 49254, RAMEvent.TYPE.ANY, (Boolean)false)),
    PDL3(new MemorySoftSwitch("Paddle3", -1, -1, 49255, RAMEvent.TYPE.ANY, (Boolean)false)),
    AN0(new MemorySoftSwitch("Annunciator0", 49240, 49241, -1, RAMEvent.TYPE.ANY, (Boolean)false)),
    AN1(new MemorySoftSwitch("Annunciator1", 49242, 49243, -1, RAMEvent.TYPE.ANY, (Boolean)false)),
    AN2(new MemorySoftSwitch("Annunciator2", 49244, 49245, -1, RAMEvent.TYPE.ANY, (Boolean)false)),
    AN3(new MemorySoftSwitch("Annunciator3", 49246, 49247, -1, RAMEvent.TYPE.ANY, (Boolean)false)),
    KEYBOARD(new KeyboardSoftSwitch("Keyboard", new int[]{49168, 3089, 49170, 49171, 49172, 49173, 49174, 49175, 49176, 49177, 49178, 49179, 49180, 49181, 49182, 49183}, null, new int[]{49152, 49153, 49154, 49155, 49156, 49157, 49158, 49159, 49160, 49161, 49162, 49163, 49164, 49165, 49166, 49167, 49168}, RAMEvent.TYPE.WRITE, (Boolean)false)),
    KEYBOARD_STROBE_READ(new SoftSwitch("KeyStrobe_Read", 49168, -1, -1, RAMEvent.TYPE.READ, (Boolean)false){

        @Override
        protected byte readSwitch() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void stateChanged() {
            KEYBOARD.getSwitch().setState(false);
        }
    }),
    TAPEOUT(new MemorySoftSwitch("TapeOut", 49184, 49184, 49248, RAMEvent.TYPE.ANY, (Boolean)false)),
    VBL(new VideoSoftSwitch("VBL", -1, -1, 49177, RAMEvent.TYPE.ANY, (Boolean)false)),
    FLOATING_BUS(new SoftSwitch("FloatingBus", null, null, new int[]{49232, 49233, 49234, 49235, 49236}, RAMEvent.TYPE.READ, null){

        @Override
        protected byte readSwitch() {
            if (Computer.getComputer().getVideo() == null) {
                return 0;
            }
            return Computer.getComputer().getVideo().getFloatingBus();
        }

        @Override
        public void stateChanged() {
        }
    });

    private SoftSwitch softswitch;

    private SoftSwitches(SoftSwitch softswitch) {
        this.softswitch = softswitch;
    }

    public SoftSwitch getSwitch() {
        return this.softswitch;
    }

    public boolean getState() {
        return this.softswitch.getState();
    }

    public final boolean isOn() {
        return this.softswitch.getState();
    }

    public final boolean isOff() {
        return !this.softswitch.getState();
    }
}

